/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class Blob {
    private static final int MAX_PRECISION = 12;
    private static final int MIN_PRECISION = 2;
    private int PRECISION;
    private int nBezPoints;
    private int nBezSegments;
    private float[][] matrix;
    private static final float SPLINE_BIAS = 0.25f;
    private static final int MAX_KNOTS = 150;
    private FPoint[] knots;
    private int nKnots;
    private Rectangle rBounds;
    private Polygon P;
    private int nPts;
    private int[] xPts;
    private int[] yPts;
    private FPoint fph;
    private FPoint fpi;
    private FPoint fpj;
    private FPoint fpk;
    private float x0;
    private float x1;
    private float x2;
    private float x3;
    private float y0;
    private float y1;
    private float y2;
    private float y3;
    private float m0;
    private float m1;
    private float m2;
    private float m3;
    private float[] M;
    private int n;
    private int nK;
    private int nKnotsm2;

    public Blob(int n) {
        this.nBezPoints = this.PRECISION;
        this.nBezSegments = this.PRECISION - 1;
        this.matrix = new float[12][4];
        this.knots = new FPoint[150];
        this.setPrecision(n);
        this.nKnots = 0;
        int n2 = 0;
        while (n2 < 150) {
            this.knots[n2] = new FPoint();
            ++n2;
        }
        this.P = new Polygon();
        this.nPts = 0;
        this.rBounds = new Rectangle();
    }

    public void clear() {
        this.nKnots = 0;
        this.nPts = 0;
    }

    public synchronized void setPrecision(int n) {
        this.nBezPoints = this.PRECISION = Math.max(2, Math.min(n, 12));
        this.nBezSegments = this.PRECISION - 1;
        this.generateInternalMatrix();
    }

    private void generateInternalMatrix() {
        int n = 0;
        while (n < this.nBezPoints) {
            float f = (float)n / (float)this.nBezSegments;
            float f2 = f * f;
            this.matrix[n][0] = f * f2;
            float f3 = 1.0f - f;
            float f4 = f3 * f3;
            this.matrix[n][1] = f3 * f4;
            this.matrix[n][2] = f * f4 * 3.0f;
            this.matrix[n][3] = f2 * f3 * 3.0f;
            ++n;
        }
    }

    public synchronized void addKnot(FPoint fPoint) {
        this.knots[this.nKnots] = fPoint;
        this.nKnots = Math.min(this.nKnots + 1, 149);
    }

    public synchronized void addKnot(float f, float f2) {
        this.knots[this.nKnots].x = f;
        this.knots[this.nKnots].y = f2;
        ++this.nKnots;
    }

    public boolean pointWithin(float f, float f2) {
        this.rBounds.x = 99999;
        this.rBounds.y = 99999;
        int n = -99999;
        int n2 = -99999;
        int n3 = 0;
        while (n3 < this.nKnots) {
            this.rBounds.x = (int)Math.min((float)this.rBounds.x, this.knots[n3].x);
            this.rBounds.y = (int)Math.min((float)this.rBounds.y, this.knots[n3].y);
            n = (int)Math.max((float)n, this.knots[n3].x);
            n2 = (int)Math.max((float)n, this.knots[n3].y);
            ++n3;
        }
        this.rBounds.height = n2 - this.rBounds.y;
        this.rBounds.width = n - this.rBounds.x;
        if (this.rBounds.contains((int)f, (int)f2)) {
            int n4 = 0;
            float f3 = 0.0f;
            int n5 = this.nKnots;
            int n6 = 0;
            while (n6 < n5 && this.knots[n6].y == f2) {
                ++n6;
            }
            int n7 = 0;
            while (n7 < n5) {
                int n8 = (n6 + 1) % n5;
                float f4 = this.knots[n8].x - this.knots[n6].x;
                float f5 = this.knots[n8].y - this.knots[n6].y;
                if (f5 != 0.0f) {
                    float f6;
                    float f7 = f - this.knots[n6].x;
                    float f8 = f2 - this.knots[n6].y;
                    if (this.knots[n8].y == f2 && this.knots[n8].x >= f) {
                        f3 = this.knots[n6].y;
                    }
                    if (this.knots[n6].y == f2 && this.knots[n6].x >= f && f3 > f2 != this.knots[n8].y > f2) {
                        --n4;
                    }
                    if ((double)(f6 = f8 / f5) >= 0.0 && (double)f6 <= 1.0 && f6 * f4 >= f7) {
                        ++n4;
                    }
                }
                n6 = n8;
                ++n7;
            }
            return n4 % 2 != 0;
        }
        return false;
    }

    public synchronized void draw(Graphics graphics) {
        if (this.nKnots > 0) {
            this.n = 0;
            this.nK = this.nKnots;
            this.nKnotsm2 = this.nKnots - 2;
            this.nPts = this.nK * this.nBezPoints;
            this.xPts = new int[this.nPts];
            this.yPts = new int[this.nPts];
            int n = 0;
            while (n < this.nK) {
                if (n > 0 && n < this.nKnotsm2) {
                    this.fph = this.knots[n - 1];
                    this.fpi = this.knots[n];
                    this.fpj = this.knots[n + 1];
                    this.fpk = this.knots[n + 2];
                } else {
                    this.fpi = this.knots[n];
                    this.fpj = this.knots[(n + 1) % this.nK];
                    this.fph = this.knots[(n - 1 + this.nK) % this.nK];
                    this.fpk = this.knots[(n + 2) % this.nK];
                }
                this.x0 = this.fpi.x;
                this.x3 = this.fpj.x;
                this.x1 = this.x0 + (this.x3 - this.fph.x) * 0.25f;
                this.y0 = this.fpi.y;
                this.y3 = this.fpj.y;
                this.y1 = this.y0 + (this.y3 - this.fph.y) * 0.25f;
                this.x2 = this.x3 - (this.fpk.x - this.x0) * 0.25f;
                this.y2 = this.y3 - (this.fpk.y - this.y0) * 0.25f;
                int n2 = 0;
                while (n2 < this.nBezPoints) {
                    this.M = this.matrix[n2];
                    this.m1 = this.M[1];
                    this.m2 = this.M[2];
                    this.m3 = this.M[3];
                    this.m0 = this.M[0];
                    this.xPts[this.n] = (int)(this.m1 * this.x0 + this.m2 * this.x1 + this.m3 * this.x2 + this.m0 * this.x3);
                    this.yPts[this.n++] = (int)(this.m1 * this.y0 + this.m2 * this.y1 + this.m3 * this.y2 + this.m0 * this.y3);
                    ++n2;
                }
                ++n;
            }
            this.P.xpoints = this.xPts;
            this.P.ypoints = this.yPts;
            this.P.npoints = this.nPts;
            graphics.fillPolygon(this.P);
        }
    }
}

