/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.util.Vector;

public class ImplicitBlob {
    private static Skeleton S;
    private static Vector joints;
    private static int nJoints;
    private static FPoint centroid;
    private static float centroidX;
    private static float centroidY;
    private static FPoint[] FPArray;
    private static final float h = 0.25f;
    private static final float h6 = 0.041666668f;
    private static final float h2 = 0.125f;
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final float K = -50000.0f;
    private static final float D;
    private static final float MAX_FORCE = 0.8f;
    private static final float MIN_FORCE = -0.8f;
    private float[] xposf;
    private float[] yposf;
    private float[] xvelf;
    private float[] yvelf;
    private int npts;
    private float threshold;
    private float[] cose;
    private float[] sine;
    private Blob B;
    private static float G1x;
    private static float G2x;
    private static float G3x;
    private static float G4x;
    private static float G1y;
    private static float G2y;
    private static float G3y;
    private static float G4y;
    private static float p1x;
    private static float v1x;
    private static float p1y;
    private static float v1y;
    private static float p2x;
    private static float v2x;
    private static float p2y;
    private static float v2y;
    private static float p3x;
    private static float v3x;
    private static float p3y;
    private static float v3y;
    private static float p4x;
    private static float v4x;
    private static float p4y;
    private static float v4y;

    static {
        D = 7.0E-4f * (float)(Math.sqrt(Math.abs(-50000.0f)) * 2.0);
    }

    public ImplicitBlob(Skeleton skeleton, float f, int n) {
        this.threshold = f;
        S = skeleton;
        joints = Skeleton.joints;
        nJoints = Skeleton.nJoints;
        S.computeCentroid();
        centroid = Skeleton.centroid;
        centroidX = ImplicitBlob.centroid.x;
        centroidY = ImplicitBlob.centroid.y;
        FPArray = new FPoint[nJoints];
        int n2 = 0;
        while (n2 < nJoints) {
            ImplicitBlob.FPArray[n2] = ((Joint)ImplicitBlob.joints.elementAt((int)n2)).position;
            ++n2;
        }
        this.npts = n;
        this.B = new Blob(5);
        this.xposf = new float[this.npts];
        this.yposf = new float[this.npts];
        this.xvelf = new float[this.npts];
        this.yvelf = new float[this.npts];
        this.cose = new float[this.npts];
        this.sine = new float[this.npts];
        float f2 = 150.0f;
        int n3 = 0;
        while (n3 < this.npts) {
            double d = (float)n3 / (float)this.npts * ((float)Math.PI * 2);
            this.cose[n3] = 150.0f * (float)Math.cos(d);
            this.sine[n3] = 150.0f * (float)Math.sin(d);
            ++n3;
        }
        this.init();
    }

    public void init() {
        int n = 0;
        while (n < this.npts) {
            this.yvelf[n] = 0.0f;
            this.xvelf[n] = 0.0f;
            this.xposf[n] = centroidX + this.cose[n];
            this.yposf[n] = centroidY + this.sine[n];
            ++n;
        }
    }

    public float calculateError() {
        float f = 0.0f;
        float f2 = 0.0f;
        int n = 1;
        while (n < this.npts) {
            float f3 = Math.abs(this.xposf[n] - this.xposf[n - 1]) + Math.abs(this.yposf[n] - this.yposf[n - 1]);
            f2 += f3;
            if (f3 > f) {
                f = f3;
            }
            ++n;
        }
        return f / (f2 /= (float)(this.npts - 1));
    }

    public void draw(Graphics graphics) {
        this.B.draw(graphics);
    }

    public void move() {
        this.B.clear();
        centroidX = ImplicitBlob.centroid.x;
        centroidY = ImplicitBlob.centroid.y;
        int n = 0;
        while (n < this.npts) {
            float f;
            float f2;
            p1x = this.xposf[n];
            p1y = this.yposf[n];
            int n2 = 0;
            float f3 = 0;
            while (n2 < nJoints) {
                f2 = p1x - ImplicitBlob.FPArray[n2].x;
                f = p1y - ImplicitBlob.FPArray[n2].y;
                f3 += 1.0f / (f2 * f2 + f * f);
                ++n2;
            }
            float f4 = p1x - centroidX;
            float f5 = p1y - centroidY;
            float f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
            float f7 = -50000.0f * (this.threshold - f3) / f6;
            f7 = f7 > 0.8f ? 0.8f : (f7 < -0.8f ? -0.8f : f7);
            v1x = this.xvelf[n];
            G1x = f7 * f4 - D * v1x;
            v1y = this.yvelf[n];
            G1y = f7 * f5 - D * v1y;
            p2x = p1x + 0.125f * v1x;
            p2y = p1y + 0.125f * v1y;
            n2 = 0;
            f3 = 0;
            while (n2 < nJoints) {
                f2 = p2x - ImplicitBlob.FPArray[n2].x;
                f = p2y - ImplicitBlob.FPArray[n2].y;
                f3 += 1.0f / (f2 * f2 + f * f);
                ++n2;
            }
            f4 = p2x - centroidX;
            f5 = p2y - centroidY;
            f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
            f7 = -50000.0f * (this.threshold - f3) / f6;
            f7 = f7 > 0.8f ? 0.8f : (f7 < -0.8f ? -0.8f : f7);
            v2x = v1x + 0.125f * G1x;
            G2x = f7 * f4 - D * v2x;
            v2y = v1y + 0.125f * G1y;
            G2y = f7 * f5 - D * v2y;
            p3x = p1x + 0.125f * v2x;
            p3y = p1y + 0.125f * v2y;
            n2 = 0;
            f3 = 0;
            while (n2 < nJoints) {
                f2 = p3x - ImplicitBlob.FPArray[n2].x;
                f = p3y - ImplicitBlob.FPArray[n2].y;
                f3 += 1.0f / (f2 * f2 + f * f);
                ++n2;
            }
            f4 = p3x - centroidX;
            f5 = p3y - centroidY;
            f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
            f7 = -50000.0f * (this.threshold - f3) / f6;
            f7 = f7 > 0.8f ? 0.8f : (f7 < -0.8f ? -0.8f : f7);
            v3x = v1x + 0.125f * G2x;
            G3x = f7 * f4 - D * v3x;
            v3y = v1y + 0.125f * G2y;
            G3y = f7 * f5 - D * v3y;
            p4x = p1x + 0.25f * v3x;
            p4y = p1y + 0.25f * v3y;
            n2 = 0;
            f3 = 0;
            while (n2 < nJoints) {
                f2 = p4x - ImplicitBlob.FPArray[n2].x;
                f = p4y - ImplicitBlob.FPArray[n2].y;
                f3 += 1.0f / (f2 * f2 + f * f);
                ++n2;
            }
            f4 = p4x - centroidX;
            f5 = p4y - centroidY;
            f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
            f7 = -50000.0f * (this.threshold - f3) / f6;
            f7 = f7 > 0.8f ? 0.8f : (f7 < -0.8f ? -0.8f : f7);
            v4x = v1x + 0.25f * G3x;
            G4x = f7 * f4 - D * v4x;
            v4y = v1y + 0.25f * G3y;
            G4y = f7 * f5 - D * v4y;
            this.xposf[n] = p1x + 0.041666668f * (v1x + 2.0f * v2x + 2.0f * v3x + v4x);
            this.xvelf[n] = v1x + 0.041666668f * (G1x + 2.0f * G2x + 2.0f * G3x + G4x);
            this.yposf[n] = p1y + 0.041666668f * (v1y + 2.0f * v2y + 2.0f * v3y + v4y);
            this.yvelf[n] = v1y + 0.041666668f * (G1y + 2.0f * G2y + 2.0f * G3y + G4y);
            this.B.addKnot(this.xposf[n], this.yposf[n]);
            ++n;
        }
    }
}

