/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class Joint {
    public FPoint position;
    public FPoint displacement;
    public FPoint velocity;
    public int id;
    private final float K = 0.0f - (0.09f + (float)(0.02 * (Math.random() - 0.5)));
    private final float D = 0.945f + (float)(0.025 * (Math.random() - 0.5));
    private static final float MAX_VELOCITY = 10.0f;
    private float mtx;
    private float mty;
    private float mth;
    private static final float MOVE_TOWARDS_ALPHA = 0.75f;
    private static final float MOVE_TOWARDS_BETA = 0.25f;
    private static final float MAX_MOVEMENT = 16.0f;
    private float forceX;
    private float forceY;

    public Joint(float f, float f2, int n) {
        this.position = new FPoint(f, f2);
        this.velocity = new FPoint();
        this.displacement = new FPoint();
        this.id = n;
    }

    public void draw(Graphics graphics) {
        int n = (int)this.position.x;
        int n2 = (int)this.position.y;
        graphics.setColor(Color.gray);
        graphics.fillOval(n - 2, n2 - 2, 5, 5);
    }

    public void set(float f, float f2) {
        this.position.set(f, f2);
    }

    public void addDisplacement(float f, float f2) {
        this.displacement.translate(f, f2);
    }

    public float getDisplacementSquared() {
        return this.displacement.x * this.displacement.x + this.displacement.y * this.displacement.y;
    }

    public void moveTowards(float f, float f2) {
        this.mtx = f - this.position.x;
        this.mty = f2 - this.position.y;
        this.mth = Math.min(1.0f, 16.0f / (float)Math.sqrt(this.mtx * this.mtx + this.mty * this.mty));
        this.position.x += this.mtx * this.mth;
        this.position.y += this.mty * this.mth;
    }

    public void update() {
        this.forceX = this.K * this.displacement.x;
        this.forceY = this.K * this.displacement.y;
        this.velocity.scale(this.D);
        this.velocity.translate(this.forceX, this.forceY);
        this.velocity.clamp(10.0f);
        this.position.translate(this.velocity);
        this.displacement.clear();
    }
}

