/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

public class Link {
    public Joint j0;
    public Joint j1;
    public FPoint fp0;
    public FPoint fp1;
    public boolean onBoundary;
    public float restLength;
    private float dx;
    private float dy;
    private float dh;
    private float stretch;
    private float strength;
    private float restLength0;

    public Link(Joint joint, Joint joint2, boolean bl, float f) {
        this.j0 = joint;
        this.j1 = joint2;
        this.fp0 = this.j0.position;
        this.fp1 = this.j1.position;
        this.onBoundary = bl;
        this.dx = this.fp0.x - this.fp1.x;
        this.dy = this.fp0.y - this.fp1.y;
        this.restLength0 = this.dh = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        this.restLength = this.dh;
        this.stretch = 0.0f;
        this.strength = f;
    }

    public void wiggle(float f, float f2) {
        double d = (float)System.currentTimeMillis() / f2;
        this.restLength = this.restLength0 * (1.0f + f * (float)Math.sin(d));
    }

    public void update() {
        this.dx = this.fp0.x - this.fp1.x;
        this.dy = this.fp0.y - this.fp1.y;
        this.dh = (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
        if (this.dh == 0.0f) {
            this.dh = 0.1f;
        }
        this.stretch = (this.dh - this.restLength) * this.strength;
        float f = this.dx / this.dh * this.stretch;
        float f2 = this.dy / this.dh * this.stretch;
        this.j0.addDisplacement(f, f2);
        this.j1.addDisplacement(-f, -f2);
    }

    public void flipBoundary() {
        this.onBoundary ^= true;
    }

    public void draw(Graphics graphics) {
        int n = (int)this.fp0.x;
        int n2 = (int)this.fp0.y;
        int n3 = (int)this.fp1.x;
        int n4 = (int)this.fp1.y;
        if (this.onBoundary) {
            graphics.setColor(Color.red);
        } else {
            graphics.setColor(Color.green);
        }
        graphics.drawLine(n, n2, n3, n4);
    }
}

