/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class ObzokApplet
extends Applet
implements Runnable {
    private static Thread animThread = null;
    private static boolean dieThread;
    private static Image canvas;
    private static int mouseX;
    private static int mouseY;
    private static boolean theMouseDown;
    private static boolean okay;
    private static final float TWO_PI = (float)Math.PI * 2;
    private static final int mandatorySleepTime = 10;
    private static final int availableTimePerFrame = 23;
    private static int canvasWidth;
    private static int canvasWidthd2;
    private static int canvasHeight;
    private static int canvasHeightd2;
    private static final String widthParam = "width";
    private static final String heightParam = "height";
    private static final String creditParam = "credit";
    private static final String backgroundParam = "background";
    private static final String foregroundParam = "foreground";
    private static Color bgColor;
    private static Color fgColor;
    private static String creditValue;
    private static Obzok obzok;
    private static Skeleton obzokSkeleton;
    private static ImplicitBlob[] IBs;
    private static Color[] blobPalette;
    private static int nIB;
    public static float obzokError;
    private static long lastInteractionTime;
    int place = 6;

    static {
        mouseX = 0;
        mouseY = 0;
        theMouseDown = false;
        okay = false;
    }

    public void init() {
        this.handleInit();
    }

    private void handleInit() {
        this.establishParameters();
        this.resize(canvasWidth, canvasHeight);
        canvas = this.createImage(canvasWidth, canvasHeight);
        this.establishSimulation();
    }

    public void start() {
        this.handleStart();
    }

    private void handleStart() {
        dieThread = false;
        this.requestFocus();
        if (animThread == null) {
            animThread = new Thread(this);
            animThread.start();
        }
    }

    public void stop() {
        this.handleStop();
    }

    private void handleStop() {
        dieThread = true;
        if (animThread != null) {
            animThread.stop();
            animThread = null;
        }
    }

    public void destroy() {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void update() {
        this.paint(this.getGraphics());
    }

    public void run() {
        this.handleRun();
    }

    private void handleRun() {
        while (animThread != null) {
            long l = System.currentTimeMillis();
            this.doSimulation();
            this.update();
            try {
                if (!dieThread) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    long l2 = System.currentTimeMillis();
                    int n = (int)(23L - (l2 - l));
                    if (n <= 0) continue;
                    try {
                        Thread.sleep(n);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (animThread == null) continue;
                animThread.stop();
                animThread = null;
            }
            catch (Exception exception) {}
            break;
        }
    }

    private void establishParameters() {
        this.setBackground(Color.darkGray);
        this.setForeground(Color.lightGray);
        bgColor = Color.darkGray;
        fgColor = Color.lightGray;
        canvasWidth = 780;
        canvasHeight = 580;
        String string = "780";
        String string2 = "580";
        String string3 = "000000";
        String string4 = "FFFFFF";
        String string5 = this.getParameter(widthParam);
        String string6 = this.getParameter(heightParam);
        String string7 = this.getParameter(backgroundParam);
        String string8 = this.getParameter(foregroundParam);
        if (string5 == null) {
            string5 = "780";
        }
        if (string6 == null) {
            string6 = "580";
        }
        if (string7 == null) {
            string7 = "000000";
        }
        if (string8 == null) {
            string8 = "FFFFFF";
        }
        canvasWidth = Integer.parseInt(string5);
        canvasHeight = Integer.parseInt(string6);
        bgColor = this.stringToColor(string7);
        fgColor = this.stringToColor(string8);
        this.setBackground(bgColor);
        this.setForeground(fgColor);
        canvasWidthd2 = canvasWidth / 2;
        canvasHeightd2 = canvasHeight / 2;
        lastInteractionTime = System.currentTimeMillis();
    }

    private Color stringToColor(String string) {
        int n = Integer.decode("0x" + string.substring(0, 2));
        int n2 = Integer.decode("0x" + string.substring(2, 4));
        int n3 = Integer.decode("0x" + string.substring(4, 6));
        return new Color(n, n2, n3);
    }

    public synchronized void paint(Graphics graphics) {
        this.handlePaint(graphics);
    }

    private synchronized void handlePaint(Graphics graphics) {
        try {
            Graphics graphics2 = canvas.getGraphics();
            graphics2.setColor(bgColor);
            graphics2.fillRect(0, 0, canvasWidth, canvasHeight);
            this.drawSimulation(graphics2);
            graphics.drawImage(canvas, 0, 0, this);
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("error:  " + ((Throwable)nullPointerException).getMessage());
        }
    }

    private void establishSimulation() {
        obzok = new Obzok();
        obzokSkeleton = Obzok.S;
        obzokSkeleton.setScreenCenter(canvasWidthd2, canvasHeightd2, this);
        nIB = 31;
        IBs = new ImplicitBlob[nIB];
        blobPalette = new Color[nIB];
        int n = 0;
        int n2 = 0;
        while (n2 < nIB) {
            float f = (float)(n2 + 1) * 8.0E-5f;
            int n3 = 8 + n2 * 4;
            ObzokApplet.IBs[n2] = new ImplicitBlob(obzokSkeleton, f, n3);
            n += n3;
            ++n2;
        }
        this.createPalette();
    }

    private void createPalette() {
        double[][] dArrayArray = new double[][]{{1.0, 2.0, 5.0}, {1.0, 5.0, 2.0}, {2.0, 1.0, 5.0}, {2.0, 5.0, 1.0}, {5.0, 1.0, 2.0}, {5.0, 2.0, 1.0}};
        int n = (int)(Math.random() * 5.99999);
        double d = dArrayArray[n][0];
        double d2 = dArrayArray[n][1];
        double d3 = dArrayArray[n][2];
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        float f = 1.04f;
        int n2 = 0;
        while (n2 < nIB) {
            float f2 = (float)n2 / (float)nIB;
            int n3 = (int)(d4 + 255.0 * Math.pow(f2 / f, d));
            int n4 = (int)(d5 + 255.0 * Math.pow(f2 / f, d2));
            int n5 = (int)(d6 + 255.0 * Math.pow(f2 / f, d3));
            ObzokApplet.blobPalette[n2] = new Color(n3, n4, n5);
            ++n2;
        }
    }

    private void doSimulation() {
        if (theMouseDown) {
            obzokSkeleton.mouseDrag(mouseX, mouseY);
        } else {
            obzokSkeleton.mouseMove(mouseX, mouseY);
        }
        obzokSkeleton.move();
        obzokSkeleton.moveCentroid();
        obzokSkeleton.computeCentroid();
        obzokError = IBs[nIB - 1].calculateError();
        if (obzokError > 10.0f) {
            this.initIBs();
        }
        int n = 0;
        while (n < nIB) {
            IBs[n].move();
            ++n;
        }
    }

    private void drawSimulation(Graphics graphics) {
        if (Skeleton.nJoints > 0) {
            int n = 0;
            while (n < nIB) {
                graphics.setColor(blobPalette[n]);
                IBs[n].draw(graphics);
                ++n;
            }
            obzok.draw(graphics);
        }
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.handleMouseDown(n, n2);
        return true;
    }

    private void handleMouseDown(int n, int n2) {
        mouseX = n;
        mouseY = n2;
        theMouseDown = true;
        long l = System.currentTimeMillis();
        if (l - lastInteractionTime > 60000L) {
            this.createPalette();
        }
        lastInteractionTime = l;
        Obzok.S.mouseDown(n, n2);
    }

    public boolean mouseUp(Event event, int n, int n2) {
        this.handleMouseUp(n, n2);
        return true;
    }

    private void handleMouseUp(int n, int n2) {
        mouseX = n;
        mouseY = n2;
        theMouseDown = false;
        Obzok.S.mouseUp(n, n2);
    }

    public boolean mouseMove(Event event, int n, int n2) {
        this.handleMouseMove(n, n2);
        return true;
    }

    private void handleMouseMove(int n, int n2) {
        mouseX = n;
        mouseY = n2;
        theMouseDown = false;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        this.handleMouseDrag(n, n2);
        return true;
    }

    private void handleMouseDrag(int n, int n2) {
        mouseX = n;
        mouseY = n2;
        theMouseDown = true;
    }

    public boolean keyDown(Event event, int n) {
        this.handleKeyDown(event, n);
        return true;
    }

    private void handleKeyDown(Event event, int n) {
        this.initIBs();
        if (n != 13 && n != 10) {
            switch ((char)n) {
                default: 
            }
        }
    }

    public void initIBs() {
        int n = 0;
        while (n < nIB) {
            IBs[n].init();
            ++n;
        }
    }
}

