/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class Skeleton {
    public static int nJoints;
    public static int nLinks;
    private static float nJointsInv;
    private static Joint[] jointArray;
    private static Link[] linkArray;
    private static FPoint[] jointFPArray;
    private static boolean constructed;
    private static int wiggleLinkID;
    private static float randomMovementAmount;
    private static float wiggleAmount;
    private static float wiggleSpeed;
    public static Vector joints;
    public static Vector links;
    public static FPoint centroid;
    private Blob B;
    private static float mouseX;
    private static float mouseY;
    private static float screenXc;
    private static float screenYc;
    private static ObzokApplet APP;
    private static float displacement;
    private static FPoint totalDisplacement;
    private static float orientation;
    private static long lastInteractionTime;
    private static final long BEDTIME = 16000L;
    private static final long SNORETIME = 6000L;
    private static final long RANDTIME = 6000L;
    private static final float HALF_PI = 1.5707964f;
    private static int grabJoint;
    private static boolean grabbed;
    private static float grabOffsetX;
    private static float grabOffsetY;
    private static final float MIN_GRAB_DISTANCE = 30.0f;
    private static final Color baseColor;
    private static float[] baseHSB;
    private static Color bodyColor;
    public static final int LEFT_EYE = 0;
    public static final int RIGHT_EYE = 1;
    private static int leftEyeStartJoint;
    private static int rightEyeStartJoint;
    private static float leftEyeR;
    private static float leftPupR;
    private static int leftEyeD;
    private static int leftPupD;
    private static int rightEyeD;
    private static int rightPupD;
    private static float rightEyeR;
    private static float rightPupR;
    private static FPoint Lj;
    private static FPoint Rj;
    private static float Lx;
    private static float Ly;
    private static float Rx;
    private static float Ry;
    private static float dxml;
    private static float dyml;
    private static float dhml;
    private static float dxpl;
    private static float dypl;
    private static float dxmr;
    private static float dymr;
    private static float dhmr;
    private static float dxpr;
    private static float dypr;
    private static float lookXl;
    private static float lookYl;
    private static float lookXr;
    private static float lookYr;
    private static float cosl;
    private static float sinl;
    private static float cosr;
    private static float sinr;
    private static float bdxl;
    private static float bdyl;
    private static float bdhl;
    private static float bdxr;
    private static float bdyr;
    private static float bdhr;
    private static float view;
    private static final float SCOPE = 200.0f;
    private static boolean deadpan;
    private static long deadpanStartTime;
    private static final long deadpanDuration = 850L;
    private static final float deadpanProbability = 0.0095f;
    private static boolean timeToBlink;
    private static long lastBlinkTime;
    private static final long minimumBlinkHiatus = 3000L;
    private static final float blinkProbability = 0.05f;
    private static final Color eyeColor;
    private static final float initialOrientation = 0.25f;
    private static final float mouthR = 70.0f;
    private static int mouthD;
    private static int mouthAng;
    private static float mouthX;
    private static float mouthY;
    private static float ux0;
    private static float ux1;
    private static float ux2;
    private static float ux3;
    private static float uy0;
    private static float uy1;
    private static float uy2;
    private static float uy3;
    private static float vx1;
    private static float vy1;
    private static float vx2;
    private static float vy2;
    private static float m0;
    private static float m1;
    private static float m2;
    private static float m3;
    private static float[] M;
    private static final int MOUTH_PTS = 8;
    private float[][] matrix = new float[8][4];
    private static float unc;
    private static boolean sleeping;
    private static Zparticle[] zees;
    private static final int nZees = 10;

    static {
        wiggleLinkID = -1;
        orientation = 0.0f;
        grabJoint = -1;
        grabbed = false;
        baseColor = new Color(255, 240, 240);
        bodyColor = new Color(255, 240, 240);
        leftEyeStartJoint = 0;
        rightEyeStartJoint = 0;
        deadpan = true;
        deadpanStartTime = 0L;
        timeToBlink = false;
        lastBlinkTime = 0L;
        eyeColor = new Color(192, 153, 153);
        mouthD = 140;
        vx1 = 0.0f;
        vy1 = 0.0f;
        vx2 = 0.0f;
        vy2 = 0.0f;
        unc = 500.0f;
    }

    public Skeleton() {
        constructed = false;
        joints = new Vector(32);
        links = new Vector(100);
        nJoints = 0;
        nLinks = 0;
        this.B = new Blob(10);
        centroid = new FPoint();
        totalDisplacement = new FPoint();
        displacement = 0.0f;
        wiggleAmount = 0.0f;
        wiggleSpeed = 500.0f;
        randomMovementAmount = 0.5f;
        lastInteractionTime = System.currentTimeMillis();
        sleeping = false;
        zees = new Zparticle[10];
        int n = 0;
        while (n < 10) {
            Skeleton.zees[n] = new Zparticle();
            ++n;
        }
        baseHSB = new float[3];
        int n2 = baseColor.getRed();
        int n3 = baseColor.getGreen();
        int n4 = baseColor.getBlue();
        Color.RGBtoHSB(n2, n3, n4, baseHSB);
        this.generateMouthMatrix();
    }

    public void setScreenCenter(float f, float f2, ObzokApplet obzokApplet) {
        mouthX = screenXc = f;
        mouthY = screenYc = f2;
        APP = obzokApplet;
    }

    public void addJoint(float f, float f2) {
        Joint joint = new Joint(f, f2, nJoints);
        joints.addElement(joint);
        ++nJoints;
    }

    public int insertJoint(float f, float f2, int n) {
        Joint joint = new Joint(f, f2, nJoints);
        joints.insertElementAt(joint, n);
        nJoints = joints.size();
        return nJoints;
    }

    public void addLink(int n, int n2, boolean bl, float f) {
        nJoints = joints.size();
        if (n >= 0 && n < joints.size() && n2 >= 0 && n2 < joints.size() && n != n2) {
            Joint joint = (Joint)joints.elementAt(n);
            Joint joint2 = (Joint)joints.elementAt(n2);
            links.addElement(new Link(joint, joint2, bl, f));
            ++nLinks;
        }
    }

    public void addWiggleLink(int n, int n2, boolean bl, float f) {
        nJoints = joints.size();
        if (n >= 0 && n < joints.size() && n2 >= 0 && n2 < joints.size() && n != n2) {
            Joint joint = (Joint)joints.elementAt(n);
            Joint joint2 = (Joint)joints.elementAt(n2);
            links.addElement(new Link(joint, joint2, bl, f));
            wiggleLinkID = nLinks++;
        }
    }

    public void finishConstructing() {
        nJoints = joints.size();
        jointArray = new Joint[nJoints];
        jointFPArray = new FPoint[nJoints];
        nLinks = links.size();
        linkArray = new Link[nLinks];
        nJointsInv = 1.0f / (float)nJoints;
        int n = 0;
        while (n < nJoints) {
            Skeleton.jointArray[n] = (Joint)joints.elementAt(n);
            Skeleton.jointFPArray[n] = Skeleton.jointArray[n].position;
            ++n;
        }
        int n2 = 0;
        while (n2 < nLinks) {
            Skeleton.linkArray[n2] = (Link)links.elementAt(n2);
            ++n2;
        }
        constructed = true;
        this.computeCentroid();
        int n3 = 0;
        while (n3 < 10) {
            zees[n3].init();
            ++n3;
        }
    }

    public void flipLinkGender(Joint joint, Joint joint2) {
        int n = 0;
        boolean bl = false;
        while (!bl && n < links.size()) {
            Link link = (Link)links.elementAt(n++);
            if (link.j0.equals(joint) && link.j1.equals(joint2)) {
                link.flipBoundary();
                bl = true;
                continue;
            }
            if (!link.j0.equals(joint2) || !link.j1.equals(joint)) continue;
            link.flipBoundary();
            bl = true;
        }
    }

    public void moveCentroid() {
        block3: {
            block2: {
                if (!constructed) break block2;
                float f = (screenXc - Skeleton.centroid.x) * 0.05f;
                float f2 = (screenYc - Skeleton.centroid.y) * 0.05f;
                int n = 0;
                while (n < nJoints) {
                    jointFPArray[n].translate(f, f2);
                    ++n;
                }
                break block3;
            }
            if (nJoints <= 0) break block3;
            float f = (screenXc - Skeleton.centroid.x) * 0.05f;
            float f3 = (screenYc - Skeleton.centroid.y) * 0.05f;
            int n = 0;
            while (n < joints.size()) {
                FPoint fPoint = ((Joint)Skeleton.joints.elementAt((int)n)).position;
                fPoint.x += f;
                fPoint.y += f3;
                ++n;
            }
        }
    }

    public synchronized void move() {
        if (constructed) {
            long l = System.currentTimeMillis() - lastInteractionTime;
            float f = (float)(Math.max(16000L, Math.min(l, 6000L)) - 16000L) / -10000.0f;
            wiggleAmount = 0.5f + 1.25f * f;
            wiggleSpeed = 700.0f;
            if (wiggleLinkID >= 0) {
                linkArray[wiggleLinkID].wiggle(wiggleAmount, wiggleSpeed);
            }
            randomMovementAmount = 0.5f * (float)Math.min(l, 6000L) / 6000.0f;
            this.moveRandomly();
            this.correctOrientation();
            int n = 0;
            while (n < nLinks) {
                linkArray[n].update();
                ++n;
            }
            n = 0;
            while (n < nJoints) {
                jointArray[n].update();
                ++n;
            }
        } else {
            int n = 0;
            while (n < (nLinks = links.size())) {
                Link link = (Link)links.elementAt(n);
                link.update();
                ++n;
            }
            int n2 = 0;
            while (n2 < (nJoints = joints.size())) {
                Joint joint = (Joint)joints.elementAt(n2);
                joint.update();
                ++n2;
            }
        }
    }

    public synchronized void mouseUp(float f, float f2) {
        lastInteractionTime = System.currentTimeMillis();
        grabbed = false;
        grabJoint = -1;
        mouseX = f;
        mouseY = f2;
    }

    public synchronized void mouseDown(float f, float f2) {
        lastInteractionTime = System.currentTimeMillis();
        mouseX = f;
        mouseY = f2;
        if (!grabbed) {
            grabJoint = -1;
            float f3 = 99999.0f;
            if (constructed) {
                int n = 0;
                while (n < nJoints) {
                    FPoint fPoint = jointFPArray[n];
                    float f4 = fPoint.x - f;
                    float f5 = fPoint.y - f2;
                    float f6 = (float)Math.sqrt(f4 * f4 + f5 * f5);
                    if (f6 < f3) {
                        f3 = f6;
                        grabJoint = n;
                        if (f6 <= 30.0f) {
                            grabOffsetX = 0.0f;
                            grabOffsetY = 0.0f;
                            grabbed = true;
                        } else {
                            grabOffsetX = f4;
                            grabOffsetY = f5;
                        }
                    }
                    ++n;
                }
                if (!grabbed && this.B.pointWithin(f, f2)) {
                    grabbed = true;
                }
            } else {
                int n = 0;
                while (n < (nJoints = joints.size())) {
                    Joint joint = (Joint)joints.elementAt(n);
                    float f7 = joint.position.x - f;
                    float f8 = joint.position.y - f2;
                    float f9 = (float)Math.sqrt(f7 * f7 + f8 * f8);
                    if (f9 < f3) {
                        f3 = f9;
                        if (f9 <= 30.0f) {
                            grabJoint = n;
                            grabbed = true;
                        }
                    }
                    ++n;
                }
            }
        }
    }

    public synchronized void mouseDrag(float f, float f2) {
        lastInteractionTime = System.currentTimeMillis();
        mouseX = f;
        mouseY = f2;
        if (grabbed && grabJoint > -1) {
            if (constructed) {
                jointArray[grabJoint].moveTowards(f + grabOffsetX, f2 + grabOffsetY);
                grabOffsetX *= 0.96f;
                grabOffsetY *= 0.96f;
            } else {
                ((Joint)joints.elementAt(grabJoint)).moveTowards(f, f2);
            }
        }
    }

    public synchronized void mouseMove(float f, float f2) {
        if (mouseX - f != 0.0f || mouseY - f2 != 0.0f) {
            lastInteractionTime = System.currentTimeMillis();
        }
        mouseX = f;
        mouseY = f2;
        grabbed = false;
        grabJoint = -1;
    }

    public void moveRandomly() {
        block2: {
            block3: {
                if (!(randomMovementAmount > 0.0f)) break block2;
                if (!constructed) break block3;
                int n = 0;
                while (n < nJoints) {
                    FPoint fPoint = jointFPArray[n];
                    fPoint.x += randomMovementAmount * (float)(Math.random() - 0.5);
                    fPoint.y += randomMovementAmount * (float)(Math.random() - 0.5);
                    ++n;
                }
                break block2;
            }
            if (nJoints <= 0) break block2;
            nJoints = joints.size();
            int n = 0;
            while (n < nJoints) {
                FPoint fPoint = ((Joint)Skeleton.joints.elementAt((int)n)).position;
                fPoint.x += (float)(Math.random() - 0.5);
                fPoint.y += (float)(Math.random() - 0.5);
                ++n;
            }
        }
    }

    public synchronized FPoint computeCentroid() {
        if (nJoints > 0) {
            if (constructed) {
                float f = 0.0f;
                float f2 = 0.0f;
                int n = 0;
                while (n < nJoints) {
                    FPoint fPoint = jointFPArray[n];
                    f += fPoint.x;
                    f2 += fPoint.y;
                    ++n;
                }
                centroid.set(f * nJointsInv, f2 * nJointsInv);
            } else {
                float f = 0.0f;
                float f3 = 0.0f;
                int n = 0;
                while (n < (nJoints = joints.size())) {
                    FPoint fPoint = ((Joint)Skeleton.joints.elementAt((int)n)).position;
                    f += fPoint.x;
                    f3 += fPoint.y;
                    ++n;
                }
                centroid.set(f /= (float)nJoints, f3 /= (float)nJoints);
            }
        }
        return centroid;
    }

    public void drawCentroid(Graphics graphics) {
        graphics.setColor(Color.yellow);
        graphics.fillOval((int)(Skeleton.centroid.x - 3.0f), (int)(Skeleton.centroid.y - 3.0f), 6, 6);
    }

    public synchronized void drawBody(Graphics graphics) {
        if (constructed) {
            this.B.clear();
            int n = 0;
            while (n < nJoints) {
                this.B.addKnot(jointFPArray[n]);
                ++n;
            }
            graphics.setColor(bodyColor);
            this.B.draw(graphics);
        } else {
            this.B.clear();
            int n = 0;
            while (n < (nJoints = joints.size())) {
                Joint joint = (Joint)joints.elementAt(n);
                this.B.addKnot(joint.position);
                ++n;
            }
            graphics.setColor(bodyColor);
            this.B.draw(graphics);
        }
    }

    public synchronized void drawStructure(Graphics graphics) {
        if (constructed) {
            int n = 0;
            while (n < nJoints) {
                jointArray[n].draw(graphics);
                ++n;
            }
            int n2 = 0;
            while (n2 < nLinks) {
                linkArray[n2].draw(graphics);
                ++n2;
            }
        } else {
            int n = 0;
            while (n < joints.size()) {
                Joint joint = (Joint)joints.elementAt(n);
                joint.draw(graphics);
                ++n;
            }
            int n3 = 0;
            while (n3 < links.size()) {
                Link link = (Link)links.elementAt(n3);
                link.draw(graphics);
                ++n3;
            }
        }
    }

    public void setEyeID(int n, int n2) {
        if (n == 0) {
            leftEyeStartJoint = n2;
            leftEyeR = 8.0f;
            leftEyeD = (int)(leftEyeR * 2.0f);
            leftPupR = leftEyeR * 0.25f;
            leftPupD = (int)(leftPupR * 2.0f + 1.0f);
        } else if (n == 1) {
            rightEyeStartJoint = n2;
            rightEyeR = 8.0f;
            rightEyeD = (int)(rightEyeR * 2.0f);
            rightPupR = rightEyeR * 0.25f;
            rightPupD = (int)(rightPupR * 2.0f + 1.0f);
        }
    }

    private void correctOrientation() {
        float f = 0.03f * (orientation - 0.25f);
        float f2 = Skeleton.centroid.x - Skeleton.jointFPArray[20].x;
        float f3 = Skeleton.centroid.y - Skeleton.jointFPArray[20].y;
        float f4 = f3 * f;
        float f5 = -f2 * f;
        jointArray[20].addDisplacement(f4, f5);
    }

    public synchronized void drawEyes(Graphics graphics) {
        Ry = 0.0f;
        Rx = 0.0f;
        Ly = 0.0f;
        Lx = 0.0f;
        int n = 0;
        while (n < 4) {
            Lj = jointFPArray[leftEyeStartJoint + n];
            Rj = jointFPArray[rightEyeStartJoint + n];
            Lx += Skeleton.Lj.x;
            Rx += Skeleton.Rj.x;
            Ly += Skeleton.Lj.y;
            Ry += Skeleton.Rj.y;
            ++n;
        }
        orientation = (float)(1.5707963267948966 + Math.atan2((double)((Ly /= 4.0f) + (Ry /= 4.0f)) * 0.5 - (double)Skeleton.centroid.y, (double)((Lx /= 4.0f) + (Rx /= 4.0f)) * 0.5 - (double)Skeleton.centroid.x));
        graphics.setColor(Color.white);
        graphics.fillOval((int)(Lx - leftEyeR + 1.0f), (int)(Ly - leftEyeR), leftEyeD, leftEyeD);
        graphics.fillOval((int)(Rx - rightEyeR + 1.0f), (int)(Ry - rightEyeR), rightEyeD, rightEyeD);
        graphics.setColor(eyeColor);
        graphics.drawOval((int)(Lx - leftEyeR), (int)(Ly - leftEyeR), leftEyeD, leftEyeD);
        graphics.drawOval((int)(Rx - rightEyeR), (int)(Ry - rightEyeR), rightEyeD, rightEyeD);
        lookXl = 0.0f;
        lookYl = 0.0f;
        lookXr = 0.0f;
        lookYr = 0.0f;
        long l = System.currentTimeMillis();
        if (deadpan) {
            if (l - deadpanStartTime > 850L) {
                deadpan = false;
            }
        } else {
            lookXl = mouseX - Lx;
            lookYl = mouseY - Ly;
            lookXr = mouseX - Rx;
            lookYr = mouseY - Ry;
            if (Math.random() < (double)0.0095f && l - deadpanStartTime > 1700L) {
                deadpanStartTime = l;
                deadpan = true;
            }
        }
        if (l - lastInteractionTime > 16000L) {
            timeToBlink = true;
            if (!sleeping) {
                int n2 = 0;
                while (n2 < 10) {
                    zees[n2].init();
                    ++n2;
                }
            }
            sleeping = true;
        } else if (l - lastBlinkTime > 3000L && Math.random() < (double)0.05f) {
            timeToBlink = true;
            lastBlinkTime = l;
            sleeping = false;
        } else {
            timeToBlink = false;
            if (sleeping) {
                APP.initIBs();
            }
            sleeping = false;
        }
        graphics.setColor(eyeColor);
        if (timeToBlink) {
            bdxl = Lx - Skeleton.centroid.x;
            bdyl = Ly - Skeleton.centroid.y;
            bdhl = leftEyeR / (float)Math.sqrt(bdxl * bdxl + bdyl * bdyl);
            cosl = bdyl * bdhl;
            sinl = bdxl * bdhl;
            bdxr = Rx - Skeleton.centroid.x;
            bdyr = Ry - Skeleton.centroid.y;
            bdhr = rightEyeR / (float)Math.sqrt(bdxr * bdxr + bdyr * bdyr);
            cosr = bdyr * bdhr;
            sinr = bdxr * bdhr;
            graphics.drawLine((int)(Lx - cosl), (int)(Ly + sinl), (int)(Lx + cosl), (int)(Ly - sinl));
            graphics.drawLine((int)(Rx - cosr), (int)(Ry + sinr), (int)(Rx + cosr), (int)(Ry - sinr));
        } else {
            dxml = 0.5f * (dxml + lookXl);
            dyml = 0.5f * (dyml + lookYl);
            dhml = (float)Math.sqrt(dxml * dxml + dyml * dyml);
            view = Math.min(dhml, 200.0f) / 200.0f * (leftEyeR * 0.6f) / dhml;
            dxpl = dxml * view;
            dypl = dyml * view;
            dxmr = 0.5f * (dxmr + lookXr);
            dymr = 0.5f * (dymr + lookYr);
            dhmr = (float)Math.sqrt(dxmr * dxmr + dymr * dymr);
            view = Math.min(dhmr, 200.0f) / 200.0f * (leftEyeR * 0.6f) / dhmr;
            dxpr = dxmr * view;
            dypr = dymr * view;
            graphics.fillOval((int)(Lx - leftPupR + dxpl), (int)(Ly - leftPupR + dypl), leftPupD, leftPupD);
            graphics.fillOval((int)(Rx - rightPupR + dxpr), (int)(Ry - rightPupR + dypr), rightPupD, rightPupD);
        }
    }

    private void generateMouthMatrix() {
        int n = 0;
        while (n < 8) {
            float f = (float)n / 7.0f;
            float f2 = f * f;
            this.matrix[n][0] = f * f2;
            float f3 = 1.0f - f;
            float f4 = f3 * f3;
            this.matrix[n][1] = f3 * f4;
            this.matrix[n][2] = f * f4 * 3.0f;
            this.matrix[n][3] = f2 * f3 * 3.0f;
            ++n;
        }
    }

    public void drawMouth(Graphics graphics) {
        graphics.setColor(eyeColor);
        mouthX = 0.5f * mouthX + 0.25f * (Skeleton.centroid.x + Skeleton.jointFPArray[20].x);
        mouthY = 0.5f * mouthY + 0.25f * (Skeleton.centroid.y + Skeleton.jointFPArray[20].y);
        float f = ObzokApplet.obzokError;
        float f2 = (11.0f + f) * (float)Math.cos(orientation);
        float f3 = (11.0f + f) * (float)Math.sin(orientation);
        ux0 = mouthX - f2;
        uy0 = mouthY - f3;
        ux3 = mouthX + f2;
        uy3 = mouthY + f3;
        float f4 = 0.99f;
        float f5 = 1.0f - f4;
        float f6 = 0.1f;
        float f7 = 1.0f - f6;
        if (grabbed) {
            if (grabJoint <= 15) {
                float f8 = f7 * 0.5f * (float)Math.sin((double)((float)System.currentTimeMillis() + (unc += (float)(Math.random() * 10.0))) / 2000.0);
                vx1 = f6 * vx1 - f3 * f8;
                vy1 = f6 * vy1 + f2 * f8;
                vx2 = f6 * vx2 + f3 * f8;
                vy2 = f6 * vy2 - f2 * f8;
            } else {
                vx1 = f4 * vx1 - f5 * f3 * 0.5f;
                vy1 = f4 * vy1 + f5 * f2 * 0.5f;
                vx2 = f4 * vx2 - f5 * f3 * 0.5f;
                vy2 = f4 * vy2 + f5 * f2 * 0.5f;
            }
        } else {
            vx1 = f4 * vx1 - f5 * f3 * 0.1f;
            vy1 = f4 * vy1 + f5 * f2 * 0.1f;
            vx2 = f4 * vx2 - f5 * f3 * 0.1f;
            vy2 = f4 * vy2 + f5 * f2 * 0.1f;
        }
        ux1 = ux0 + 0.33f * (ux3 - ux0) + vx1;
        uy1 = uy0 + 0.33f * (uy3 - uy0) + vy1;
        ux2 = ux0 + 0.66f * (ux3 - ux0) + vx2;
        uy2 = uy0 + 0.66f * (uy3 - uy0) + vy2;
        int n = (int)ux0;
        int n2 = (int)uy0;
        int n3 = 1;
        while (n3 < 8) {
            M = this.matrix[n3];
            m1 = M[1];
            m2 = M[2];
            m3 = M[3];
            m0 = M[0];
            int n4 = (int)(m1 * ux0 + m2 * ux1 + m3 * ux2 + m0 * ux3);
            int n5 = (int)(m1 * uy0 + m2 * uy1 + m3 * uy2 + m0 * uy3);
            graphics.drawLine(n, n2, n4, n5);
            n = n4;
            n2 = n5;
            ++n3;
        }
    }

    public void drawZees(Graphics graphics) {
        if (sleeping) {
            graphics.setColor(bodyColor);
            int n = 0;
            while (n < 10) {
                zees[n].draw(graphics);
                zees[n].move();
                ++n;
            }
        }
    }

    private class Zparticle {
        private FPoint position = new FPoint();
        private FPoint velocity = new FPoint();
        private Font F;
        private float fx;
        private float fy;

        public Zparticle() {
            this.init();
            this.F = new Font("Helvetica", 0, (int)(8.0 + Math.random() * 10.0));
        }

        public void init() {
            this.position.set(Skeleton.centroid.x, Skeleton.centroid.y);
            this.velocity.clear();
        }

        public void move() {
            this.fx = (this.fx + (float)(Math.random() - 0.5)) * 0.5f;
            this.fy = (this.fy + (float)(Math.random() - 0.7)) * 0.5f;
            this.velocity.scale(0.9f);
            this.velocity.translate(this.fx, this.fy);
            this.position.translate(this.velocity);
            if (this.position.y < 0.0f) {
                this.init();
            }
        }

        public void draw(Graphics graphics) {
            graphics.setFont(this.F);
            graphics.drawString("z", (int)this.position.x, (int)this.position.y);
        }
    }
}

